
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MESS_IO.C - Message Data Type Support (NavCore family)
// 
//
//   DESCRIPTION
//
//   Functions for storing and retrieving data elements used by the NavCore
//   family of receivers.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MESS_IO.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:42   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:34:52   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:10   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:24:38   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:52:34   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <math.h>

#include "LABMON.H"

extern unsigned char msgbuff[MAX_MSG_BUFFER];              /* Local Buffer */
extern unsigned char rx_buff[MAX_RX_BUFFER+1];     /* Interrupt Buffer */
extern unsigned short head;
extern unsigned char tx_buff[MAX_TX_BUFFER];

extern short cmdline;

typedef union {
      unsigned char  bd[8];
      short      iv;
      long       lv;
      float      fv;
      double     dv;
} tVALUE;

static tVALUE valu;

short get_cs(BYTE *buf, short len)
{
   short i;
   unsigned long cs;

   for(i=0,cs=0L;i<len;i+=2)
      cs += *(short*)(buf+i);

   return (short)(cs & 0xFFFF);
}


short get_I16(unsigned char i) /* Get A 2 Byte Integer From Message Buffer */
{
   short iv;

   i --; i *=2;               // convert to bytes

   iv =  *(BYTE *)(msgbuff+i+1);  iv = iv << 8;
   iv |= *(BYTE *)(msgbuff+i);

   return iv;
}


long get_I32(short i) /* Get A 4 Byte Long Integer From Message Buffer */
{
   long lv;

   i --; i *=2;               // convert to bytes
   
   lv =  *(BYTE *)(msgbuff+i+3);  lv = lv << 8;
   lv |= *(BYTE *)(msgbuff+i+2);  lv = lv << 8;
   lv |= *(BYTE *)(msgbuff+i+1);  lv = lv << 8;
   lv |= *(BYTE *)(msgbuff+i);

   return lv;

}


float get_F24(short i) /* Get A 4 Byte Float From Message Buffer */
{
   double Mantissa, Exponent, Sign;
   short j, tmp;
   unsigned long lv;
   
   tmp = 0;  // ** added

   i --; i *=2;               // convert to bytes

   for(j=0;j<4;j++) tmp |= *(BYTE *)(msgbuff+i+j);
   if (tmp==0) return 0.0F;     // ** added F

   if(msgbuff[i+3]&0x80)
      Sign = -1.0;
   else Sign = 1.0;
   
   lv =  *(BYTE *)(msgbuff+i+3);  lv = lv << 8;
   lv |= *(BYTE *)(msgbuff+i+2);  lv = lv << 8;
   lv |= *(BYTE *)(msgbuff+i+1);
   lv |= 0x800000;

   Mantissa = lv * pow(2.0,-24.0);

   Exponent = *(BYTE *)(msgbuff+i) - 128;                  //Normalize exponent

   return (float)(Mantissa * pow(2.0,Exponent) * Sign);

}


double get_F40(short i) /* Get A 6 byte Float From Buffer, Return A Double */
{
   double Mantissa, Exponent, Sign;
   short j, tmp;       
   
   tmp = 0; // ** added

   i --; i *=2;               // convert to bytes
   
   for(j=0;j<6;j++) tmp |= msgbuff[i+j];
   if (tmp==0) return 0.0;

   if(msgbuff[i+5]&0x80)
      Sign = -1;
   else Sign = 1;

   Mantissa =  *(BYTE *)(msgbuff+i+1); Mantissa /= 256.0; 
   Mantissa += *(BYTE *)(msgbuff+i+2); Mantissa /= 256.0;
   Mantissa += *(BYTE *)(msgbuff+i+3); Mantissa /= 256.0; 
   Mantissa += *(BYTE *)(msgbuff+i+4); Mantissa /= 256.0; 
   Mantissa += *(BYTE *)(msgbuff+i+5) & 0x7F; Mantissa /= 256.0; 
   Mantissa += 0.5;
   
   Exponent = *(BYTE *)(msgbuff+i) - 128;                  // Normalize exponent

   return (double)(Mantissa * pow(2.0,Exponent) * Sign);

}


void make_short(short value ,unsigned char *tx_buff, short offset)
{
   offset --; offset *= 2;
   *(short*)(tx_buff+offset) = value;
}

void make_long(long value,unsigned char *tx_buff, short offset)
{
   offset --; offset *= 2;
   *(long*)(tx_buff+offset) = value;
}

void make_F24(double ieee,unsigned char *caps, short offset) /* IEEE Double - F24(4-byte) */
{
   unsigned char bp[4];
   short i;
   valu.fv = (float)ieee;

   offset --; offset *= 2;

   if (valu.fv == 0.0f) *((float *)bp) = 0.0f;
   else
   {
      bp[3] = (BYTE)(valu.bd[3] & 0x80);                 /* Sign Bit */
      bp[0] = (BYTE)((valu.bd[3]  & 0x7F) << 1);         /* MSB Of Exponent */
      if (valu.bd[2]  & 0x80) bp[0]++;                   /* LSB Of Exponent */
      bp[3] |= (valu.bd[2] & 0x7F);                      /* First Mantissa Plus Sign */
      bp[2] = (valu.bd[1]);                              /* Second Mantissa */
      bp[1] = (valu.bd[0]);                              /* Third Mantissa */
      bp[0] = (BYTE)((bp[0] - 0x7E)^0x80);               /* Normalize And Invert Sign */
   }
   for(i=0;i<4;i++) caps[i + offset] = bp[i];
}


void make_F40(double ieee,unsigned char *caps, short offset)           /* IEEE Double - F40(6-byte) */
{
   char bp[8];
   short i;

   offset --; offset *= 2;

   valu.dv = ieee;
   if (ieee == 0.0) *((double *)bp) = 0.0;
   else
   {
      bp[5] = (BYTE)(valu.bd[7] & 0x80);                 /* Sign Bit */

      bp[0] = (BYTE)((valu.bd[7]  & 0x40) << 1);         /* Sign Bit For Exponent */
      bp[0] |= ((valu.bd[7]  & 0x07) << 4);              /* MSB Of Exponent */
      bp[0] |= ((valu.bd[6]  & 0xF0) >> 4);              /* LSB Of Exponent */
      bp[0] = (BYTE)((bp[0] - 0x7E)^0x80);               /* Normalize And Invert Sign */

      bp[5] |= (valu.bd[6]  & 0x0F)<<3 ;                 /* MSB Of First Mantissa Plus Sign */
      bp[5] |= (valu.bd[5]  & 0xE0)>>5 ;                 /* LSB Of First Mantissa Plus Sign */

      bp[4] = (BYTE)((valu.bd[5] & 0x1F)<<3);            /* MSB Of Second Mantissa */
      bp[4] |= (valu.bd[4]  & 0xE0)>>5 ;                 /* LSB Of Second Mantissa */

      bp[3] = (BYTE)((valu.bd[4]  & 0x1F)<<3);           /* MSB Of Third Mantissa */
      bp[3] |= (valu.bd[3]  & 0xE0)>>5 ;                 /* LSB Of Third Mantissa */

      bp[2] = (BYTE)((valu.bd[3] & 0x1F)<<3);            /* MSB Of Fourth Mantissa */
      bp[2] |= (valu.bd[2] & 0xE0)>>5 ;                  /* LSB Of Fourth Mantissa */

      bp[1] = (BYTE)((valu.bd[2] & 0x1F)<<3);            /* MSB Of Fifth Mantissa */
      bp[1] |= (valu.bd[1]  & 0xE0)>>5 ;                 /* LSB Of Fifth Mantissa */
   }
   for (i=0; i<6; i++) caps[i + offset] = bp[i];
}
